//---------------------------------------------------------------------------------------------
// Torque Game Builder
// Copyright (C) GarageGames.com, Inc. EXCEPT NOT!
//---------------------------------------------------------------------------------------------


//Basic game design..
//GridSO::showGame and GridSO::hideGame()	-	Toggle visibility of all Block objects on GridSO and possibly the grid itself (?).
//createLevel()														- Create a grid script object. Generate random blocks on it using generateLevel(level).
//GridSO::generateLevel()									- Generate level on a grid SO. Creates Block objects.
//GridSO::updateLevel()										- Call Block::update() on all blocks in gridSO.
//GridSO::Block::update()									-	Checks if block should move down, if it should, does so using Block::moveTo().
//selectBlock()														- Select block (X,Y in grid), find connected blocks, set chain global vars, start chain graphic/animation.
//explodeChain()													- Blocks in chain global vars call .explodeBlock(). Should call updateLevel().
//explodeBlock()													-	Delete, play explosion at block.
//checkGameOver()													- Check if any valid chains exist. Should be called by updateLevel().

//TODO
//-Document functions up here (a lot of these dont exist/are different)
//-Add explosions (particles or 2D animation?)
//-Add sounds
//-Add scoring
//-Add deselecting of chain (might be done?)
//-ADD/TEST ROW MOVEMENT
//make row movement WAIT until column movement is done
//-NEW INPUT METHOD
//	-Must not allow input until blocks have moved OR be independent of block movement (predict where blocks will be)!
//	-Add clicking on your chain again does explode (just copy current right-click function)
//getWord($blockSize, 0)

$blockLayer = 3;				//layer blocks are rendered on.
$sceneGraph = defaultScenegraph; //custom named scenegraph (check game/data/levels/untitled.cs)
$animationTime = 50;    //speed to animate blocks (time to wait between advancing frame) - 50 looks right for the old blocks
$explosionAnimationTime = 10;    //speed to animate explosions
$chainAnimationTime = 20;    //speed to animate the cool squiggly between blocks in a chain (looks better faster)
$blockMoveSpeed = 65;	  //speed at which blocks drop (both down and left) - 65 is about right
$gameOverDelay = 500;  //time to wait before calling gameOverCheck from updateRow
$mediumExplosionCutoff = 6; //point where explosion will be considered "medium" (INCLUDES this number)
$largeExplosionCutoff = 16; //point where the explosion will be considered "large" (INCLUDES this number)
$announcerCutoff = 20;			//point where announcer will say something - 22 is historically correct
$waitMessage = "Awaiting your command.";

//Original test size
//$blockSize = "10 10";		//Block size, X Y
//$centerConnectSize = "1 1";
//$chainWidth = "2";
//$debrisSize = "2 2";

//New size (allows for bigger grid)
$blockSize = "8.5 8.5";		//Block size, X Y
//$centerConnectSize = "0.80 0.80";
//$chainWidth = "1.6";

$currentScore = 0;

//exec GUIs
exec("./gameGui.gui");
exec("./optionsGui.gui");

//exec audio datablocks
exec("./audioDatablocks.cs");

//---------------------------------------------------------------------------------------------
// startGame
// All game logic should be set up here. This will be called by the level builder when you
// select "Run Game" or by the startup process of your game to load the first level.
//---------------------------------------------------------------------------------------------
function startGame(%level)
{
   Canvas.setContent(mainScreenGui);
   Canvas.setCursor(DefaultCursor);
   
   new ActionMap(moveMap);   
   moveMap.push();
   
	 moveMap.bind(keyboard, "s", keyStartRandomLevel);
	 moveMap.bind(keyboard, "ctrl o", toggleOptionsGui);
	 
   $enableDirectInput = true;
   activateDirectInput();
   
   $centerConnectSize = (getWord($blockSize, 0) / 10) SPC (getWord($blockSize, 1) / 10);
   $chainWidth = getWord($blockSize, 0) / 5;
   $debrisSize = (getWord($blockSize, 0) / 5) SPC (getWord($blockSize, 1) / 5);
   
   sceneWindow2D.loadLevel(%level);
	 schedule(500, 0, "createBackground");
	 schedule(550, 0, "animateBackground1");
	 $music = alxPlay(gameMusic);
}

//function createBottom()
//{
//	%pos = sceneWindow2D.getCurrentCameraArea();
//	%pos = getWord(%pos, 0) - 10 SPC getWord(%pos, 2);
//	$bottom = new t2dStaticSprite()
//	{
//			imageMap = "block1";
//			size = "150 2";
//			Layer = $blockLayer - 2;
//			position = %pos;
//			CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
//			visible = 0;
//	};
//	$sceneGraph.add($bottom);
	
//	$bottom.setImmovable(1);
//	$bottom.setCollisionActive(1, 1);
//	$bottom.setCollisionMasks(BIT($blockLayer - 2), BIT($blockLayer - 2));
//}

function createBackground()
{
	if(isObject($background))
		$background.delete();
	
	%pos = sceneWindow2D.getCurrentCameraArea();
	%size = t2dVectorSub(getWords(%pos, 2, 3), getWords(%pos, 0, 1));
	%pos = sceneWindow2D.getPosition();
	
	$background = new t2dStaticSprite()
	{
			imageMap = "background";
			size = %size;
			Layer = $blockLayer + 4;
			position = %pos;
			CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
			visible = 1;
	};
	$sceneGraph.add($background);
	
	$background.setImmovable(1);
}

$bgColor = getRandom(1, 3);
$bgGoingUp = 1;
function animateBackground1()
{
	%bgcolor = $background.getBlendColour();
	%c1 = getWord(%bgColor, 0);
	%c2 = getWord(%bgColor, 1);
	%c3 = getWord(%bgColor, 2);
	
	if($bgGoingUp)
		%c[$bgColor] += 0.005;
	else
		%c[$bgColor] -= 0.005;
	
	$background.setBlendColour(%c1, %c2, %c3, 1);
	
	if(%c[$bgColor] >= 1 || %c[$bgColor] <= 0)
	{
		if(getRandom(0, 1))
			$bgColor++;
		else
			$bgColor--;
		
		if($bgColor < 1)
			$bgColor = 3;
		if($bgColor > 3)
			$bgColor = 1;
			
		if(%c[$bgColor] == 1)
			$bgGoingUp = 0;
		else
			$bgGoingUp = 1;
			
		$bgSched = schedule(800, 0, "animateBackground1");
		return;
	}
	
	$bgAnimate1Count++;
	if($bgAnimate1Count >= 140)
	{
		$bgAnimate1Count = 0;
		$bgColor = getRandom(1, 3);
	}

	$bgSched = schedule(40, 0, "animateBackground1");
}

//---------------------------------------------------------------------------------------------
// endGame
// Game cleanup should be done here.
//---------------------------------------------------------------------------------------------
function endGame()
{
   sceneWindow2D.endLevel();
   moveMap.pop();
   moveMap.delete();
   alxStopAll();
}

function keyStartRandomLevel(%val)
{
	if(%val)
	{
		chainText.setText("Click a chain of 2 or more. \nRightclick to explode.");
		if(isObject($Grid))
		{
			resetScore();
			displayCurrentScore();
			$Grid.unDisplayChain();
			$Grid.delete();
		}
		
		$Grid = createGrid("", "", 3);
		$Grid.generateGrid();
		$Grid.animateAll();
		$Grid.animateChainDisplay();
		alxPlay(levelStart);
	}
}

//=================================================================
//game programming
//probably should be in its own file
//=================================================================

//this list isn't up to date at all
//I should probably fix that but I'm lazy so no

//createLevel()														- Create a grid script object. Generate random blocks on it using generateLevel(level). - DONE
//GridSO::generateGrid()									- Generate level on a grid SO. Creates Block objects. - DONE (work on random generator later? it's not that random)
//GridSO::update()												- Call Block::update() on all blocks in gridSO. -DONE
//=========NEW=========
//gridSO::animateAll()										- Run Block.doAnimation() on all blocks in gridSO. -DONE

function createGrid(%x, %y, %varieties)
{
	if(!%x)
		%x = 11; //9
	if(!%y)	
		%y = 7; //6
	if(%varieties <= 2)
		%varieties = 3;
	
	%grid = new scriptObject()
	{
		class = "gridSO";
		sizeX = %x;
		sizeY = %y;
		varietyCount = %varieties;
	};
	%grid.chainDisplayGroup = new simGroup();
	%grid.movingDownGroup = new simGroup();
	%grid.debrisGroup = new simGroup();
	%grid.addVarietyRemainingGui();
	%grid.schedule(30, "updateVarietyRemaining");
	return(%grid);
}

function gridSO::generateGrid(%this)
{
	%varieties = %this.varietyCount;
	%sizex = %this.sizeX;
	%sizey = %this.sizeY;
	
	%topX = getWord(sceneWindow2D.getCurrentCameraArea(), 0) + 5;
	%topY = getWord(sceneWindow2D.getCurrentCameraArea(), 1) + 5 - 5; //offset to leave room for stats at the bottom (-5)
	
	//get top for centered
	%topX = %topX + ((getWord(sceneWindow2D.getCurrentCameraSize(), 0) - (%sizex * getWord($blockSize, 0))) / 2);
	%topY = %topY + ((getWord(sceneWindow2D.getCurrentCameraSize(), 1) - (%sizey * getWord($blockSize, 1))) / 2);
	
	for(%y = 0; %y < %sizeY; %y++)
	{
		for(%x = 0; %x < %sizeX; %x++)
		{
			%this.block[%x @ "_" @ %y @ "Type"] = getRandom(1, %varieties);
			%this.block[%x @ "_" @ %y @ "Object"] = new t2dStaticSprite()
			{
				imageMap = "block" @ %this.block[%x @ "_" @ %y @ "Type"];
				canSaveDynamicFields = "1";
				size = $blockSize;
				Layer = $blockLayer;
				position = %topX + (%x * getWord($blockSize, 0)) SPC %topY + (%y * getWord($blockSize, 1));
				gridX = %x;
				gridY = %y;
				CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
			};
			$sceneGraph.add(%this.block[%x @ "_" @ %y @ "Object"]);
		}
	}
}

function gridSO::animateAll(%this)
{
	%sizex = %this.sizeX;
	%sizey = %this.sizeY;

	for(%y = 0; %y < %sizeY; %y++)
	{
		for(%x = 0; %x < %sizeX; %x++)
		{
			if(isObject(%this.block[%x @ "_" @ %y @ "Object"]))
				%this.block[%x @ "_" @ %y @ "Object"].doAnimation();
		}
	}
	
	%this.animationSched = %this.schedule($animationTime, "animateAll");
}

function gridSO::animateChainDisplay(%this)
{
	//if(!isObject(%this))
	//	return;
	
	//if(!isObject(%this.chainDisplayGroup))
	
	for(%i = 0; %i < %this.chainDisplayGroup.getCount(); %i++)
	{
		%obj = %this.chainDisplayGroup.getObject(%i);
		if(isObject(%obj) && %obj.imageMap !$= "centerConnect")
			%obj.doAnimation();
	}
	
		
	//animate debris
	for(%i = 0; %i < %this.debrisGroup.getCount(); %i++)
	{
		%obj = %this.debrisGroup.getObject(%i);
		if(isObject(%obj))
			%obj.doAnimation();
	}
	
	%this.chainAnimationSched = %this.schedule($chainAnimationTime, "animateChainDisplay");
}

//more gameplay-y stuff
function gridSO::addBlockToChain(%this, %x, %y)
{
	if(%this.blockInChain(%x, %y))
	{
		error("Double adding addBlockToChain! Bad! Bad! Could lead to infinite loop!");
		return;
	}
	
	if(%this.blocksAddedToChain > %this.sizeX * %this.sizeY)
	{
		error("stopping - blocksAdded hit zero - THIS MEANS INFINITE LOOP SOMEWHERE (prevented)");
		return;
	}
	
	//add block to chain vars
	if(%this.chainCount $= "")
		%this.chainCount = 0;
	
	%this.chain[%this.chainCount] = %x SPC %y;
	%this.chainCount++;
	%this.blocksAddedToChain++;
	
	%type = %this.getBlockType(%x, %y);
	
	//check in 4 directions for possible additions
	if((%x + 1 < %this.sizeX) && !%this.blockInChain(%x + 1, %y) && %this.getBlockType(%x + 1, %y) == %type)
	{
		%this.addBlockToChain(%x + 1, %y);
	}
	if((%x - 1 >= 0) && !%this.blockInChain(%x - 1, %y) && %this.getBlockType(%x - 1, %y) == %type)
	{
		%this.addBlockToChain(%x - 1, %y);
	}
	if((%y + 1 < %this.sizeY) && !%this.blockInChain(%x, %y + 1) && %this.getBlockType(%x, %y + 1) == %type)
	{
		%this.addBlockToChain(%x, %y + 1);
	}
	if((%y - 1 >= 0) && !%this.blockInChain(%x, %y - 1) && %this.getBlockType(%x, %y - 1) == %type)
	{
		%this.addBlockToChain(%x, %y - 1);
	}
}

function gridSO::blockIsSingle(%this, %x, %y)
{
	%type = %this.getBlockType(%x, %y);
	if((%x + 1 < %this.sizeX) && %this.getBlockType(%x + 1, %y) == %type)
		return(0);
		
	if((%x - 1 >= 0) && %this.getBlockType(%x - 1, %y) == %type)
		return(0);
		
	if((%y + 1 < %this.sizeY) && %this.getBlockType(%x, %y + 1) == %type)
		return(0);
		
	if((%y - 1 >= 0) && %this.getBlockType(%x, %y - 1) == %type)
		return(0);
		
	return(1);
}

function gridSO::blockInChain(%this, %x, %y)
{
	for(%i = 0; %i < %this.chainCount; %i++)
	{
		if(%this.chain[%i] $= (%x SPC %y))
		{
			return(1);
		}
	}
	return(0);
}

function gridSO::explodeChain(%this)
{
	if(%this.chainCount == 0)
		return;
	
	%chainSize = %this.chainCount;
	
	if(%chainSize < $mediumExplosionCutoff)
	{
		%size = "small";
		sceneWindow2D.startCameraShake(8, 0.3);
	}
	if(%chainSize >= $mediumExplosionCutoff && %chainSize < $largeExplosionCutoff)
	{
		%size = "medium";
		sceneWindow2D.startCameraShake(30, 0.5);
	}
	if(%chainSize >= $largeExplosionCutoff)
	{
		%size = "large";
		sceneWindow2D.startCameraShake(55, 0.78);
	}
	
	//find width and height of the chain
	%highestX = -99;
	%highestY = -99;
	%lowestX = 99;
	%lowestY = 99;
	for(%i = 0; %i < %this.chainCount; %i++)
	{
		%x = getWord(%this.chain[%i], 0);
		%y = getWord(%this.chain[%i], 1);
		
		if(%x > %highestX)
			%highestX = %x;
		if(%y > %highestY)
			%highestY = %y;
		if(%x < %lowestX)
			%lowestX = %x;
		if(%y < %lowestY)
			%lowestY = %y;
	}
	
	%width = %highestX - %lowestX + 1;
	%height = (%highestY) - (%lowestY) + 1;
	
	//play random sound depending on size of explosion
	%this.playExplosionSounds(%size, %chainSize, %highestX, %lowestX);
	
	//do scoring
	%this.doChainScoring(%size, %chainSize);
	
	for(%i = 0; %i < %this.chainCount; %i++)
	{
		%x = getWord(%this.chain[%i], 0);
		%y = getWord(%this.chain[%i], 1);
		
		%this.explodeBlock(%x, %y, %this.block[%x @ "_" @ %y @ "Type"], %chainSize, %size, %width, %height);
		
		%this.block[%x @ "_" @ %y @ "Object"].delete();
		%this.block[%x @ "_" @ %y @ "Type"] = "";
	}
	%this.clearChain();
	
	%this.updateVarietyRemaining();
}

function gridSO::getChainStats(%this)
{
	%chainSize = %this.chainCount;
	
	if(%chainSize < $mediumExplosionCutoff)
		%size = "small";
	
	if(%chainSize >= $mediumExplosionCutoff && %chainSize < $largeExplosionCutoff)
		%size = "medium";
	
	if(%chainSize >= $largeExplosionCutoff)
		%size = "large";
	
	//find width and height of the chain
	%highestX = -99;
	%highestY = -99;
	%lowestX = 99;
	%lowestY = 99;
	for(%i = 0; %i < %this.chainCount; %i++)
	{
		%x = getWord(%this.chain[%i], 0);
		%y = getWord(%this.chain[%i], 1);
		
		if(%x > %highestX)
			%highestX = %x;
		if(%y > %highestY)
			%highestY = %y;
		if(%x < %lowestX)
			%lowestX = %x;
		if(%y < %lowestY)
			%lowestY = %y;
	}
	
	%width = %highestX - %lowestX + 1;
	%height = (%highestY) - (%lowestY) + 1;
	
	%score = mPow(%this.varietyCount, 3) * mPow((%chainSize - 1), 2);
	return(%chainSize SPC %size SPC %width SPC %height SPC %score);
}

//convert a number to hex
//function convertToHex(%num)
//{
//	//hex can be up to 255 - or, FF
//	if(%num > 255)
//		return("ERROR");
//}

function gridSO::displayChain(%this)
{
	%stats = %this.getChainStats();
	
	%color = "ff0000";
	%colorScore = "E9DF95";
	
	chainText.setText("<color:" @ %color @ ">Size: " @ getWord(%stats, 0) @ " (" @ getWord(%stats, 1) @ "). " @ getWord(%stats, 2) @ "x" @ getWord(%stats, 3) @ ".\n<color:" @ %colorScore @ ">" @ getWord(%stats, 4) @ " points.");
	
	if(%this.chainDisplayGroup.getCount() > 0)
		%this.unDisplayChain();
	
	for(%i = 0; %i < %this.chainCount; %i++)
	{
		%obj = %this.getBlockObject(getWord(%this.chain[%i], 0), getWord(%this.chain[%i], 1));
		
		%displayObj = new t2dStaticSprite()
		{
				imageMap = "centerConnect";
				canSaveDynamicFields = "1";
				size = $centerConnectSize;
				Layer = $blockLayer - 2;
				position = %obj.getPosition();
				CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
		};
		$sceneGraph.add(%displayObj);
		%this.chainDisplayGroup.add(%displayObj);
		
		%curWord = 0;
		%x = getWord(%this.chain[%i], 0);
		%y = getWord(%this.chain[%i], 1);
		%type = %this.getBlockType(%x, %y);
		
		if((%x + 1 < %this.sizeX)  && %this.getBlockType(%x + 1, %y) == %type)
		{
			%displayObj = new t2dStaticSprite()
				{
					imageMap = "rightConnect";
					canSaveDynamicFields = "1";
					size = (getWord($blockSize, 0) / 2) SPC $chainWidth;
					Layer = $blockLayer - 1;
					position = %obj.getPositionX() + (getWord($blockSize, 0) / 4) SPC %obj.getPositionY();
					CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
				};
				%this.chainDisplayGroup.add(%displayObj);
				$sceneGraph.add(%displayObj);
		}
		if((%x - 1 >= 0) && %this.getBlockType(%x - 1, %y) == %type)
		{
			%displayObj = new t2dStaticSprite()
				{
					imageMap = "leftConnect";
					canSaveDynamicFields = "1";
					size = (getWord($blockSize, 0) / 2) SPC $chainWidth;
					Layer = $blockLayer - 1;
					position = %obj.getPositionX() - (getWord($blockSize, 0) / 4) SPC %obj.getPositionY();
					CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
				};
				%this.chainDisplayGroup.add(%displayObj);
				$sceneGraph.add(%displayObj);
		}
		if((%y + 1 < %this.sizeY) && %this.getBlockType(%x, %y + 1) == %type)
		{
			%displayObj = new t2dStaticSprite()
				{
					imageMap = "downConnect";
					canSaveDynamicFields = "1";
					size =  ($chainWidth) SPC (getWord($blockSize, 1) / 2);
					Layer = $blockLayer - 1;
					position = %obj.getPositionX() SPC %obj.getPositionY() + (getWord($blockSize, 1) / 4);
					CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
				};
				%this.chainDisplayGroup.add(%displayObj);
				$sceneGraph.add(%displayObj);
		}
		if((%y - 1 >= 0) && %this.getBlockType(%x, %y - 1) == %type)
		{
			%displayObj = new t2dStaticSprite()
				{
					imageMap = "upConnect";
					canSaveDynamicFields = "1";
					size =  ($chainWidth) SPC (getWord($blockSize, 1) / 2);
					Layer = $blockLayer - 1;
					position = %obj.getPositionX() SPC %obj.getPositionY() - (getWord($blockSize, 1) / 4);
					CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
				};
				%this.chainDisplayGroup.add(%displayObj);
				$sceneGraph.add(%displayObj);
		}
	}
}

function gridSO::unDisplayChain(%this)
{
	for(%i = 0; %i < %this.chainDisplayGroup.getCount(); %i++)
	{
		%this.chainDisplayGroup.getObject(%i).schedule(10, delete);
	}
}

function gridSO::clearChain(%this, %hideWaitMsg)
{
	%this.unDisplayChain();
	
	if(!%hideWaitMsg)
		chainText.setText($waitMessage);
	
	for(%i = 0; %i < %this.chainCount; %i++)
	{
		%this.chain[%i] = "";
	}
	%this.chainCount = 0;
	%this.blocksAddedToChain = 0;
}

function gridSO::getBlockType(%this, %x, %y)
{
	return(%this.block[%x @ "_" @ %y @ "Type"]);
}

function gridSO::getBlockObject(%this, %x, %y)
{
	return(%this.block[%x @ "_" @ %y @ "Object"]);
}


//block movement
function gridSO::updateGrid(%this)
{
	$updatedRow = 0;
	for(%x = 0; %x < %this.sizeX; %x++)
	{
		%this.updateColumn(%x);
	}
	
	if($Grid.movingDownGroup.getCount() == 0)
	{
		%this.updateRow();
	}
}

//update an entire column (move down), input X value
function gridSO::updateColumn(%this, %x)
{
	//does some math for moving the blocks later
	%topX = getWord(sceneWindow2D.getCurrentCameraArea(), 0) + 5;
	%topY = getWord(sceneWindow2D.getCurrentCameraArea(), 1) + 5 - 5; //offset to leave room for stats at the bottom (-5)
	%topX = %topX + ((getWord(sceneWindow2D.getCurrentCameraSize(), 0) - (%this.sizeX * getWord($blockSize, 0))) / 2);
	%topY = %topY + ((getWord(sceneWindow2D.getCurrentCameraSize(), 1) - (%this.sizeY * getWord($blockSize, 1))) / 2);
	
	for(%y = %this.sizeY - 2; %y >= 0; %y--) //start one block up from the top
	{
		%obj = %this.getBlockObject(%x, %y);
		if(isObject(%obj))
		{
			%count = 1;
			%nextObj = %this.block[%x @ "_" @ %y + %count @ "Object"];
			if(!isObject(%nextObj))
			{
				while(!isObject(%nextObj) && %count + %y < %this.sizeY - 1)
				{
					%count++;
					%nextObj = %this.block[%x @ "_" @ %y + %count @ "Object"];
				}
				
				if(%count > 1)
					%count--;
				
				//move it - can't use function because it must be done instantly, before the next "for" loop
				//set x2 and y2 values (move it in the gridSO)
				%x1 = %x;
				%y1 = %y;
				%x2 = %x;
				%y2 = %y + %count;
				%this.block[%x2 @ "_" @ %y2 @ "Object"] = %this.block[%x1 @ "_" @ %y1 @ "Object"];
				%this.block[%x2 @ "_" @ %y2 @ "Type"] = %this.block[%x1 @ "_" @ %y1 @ "Type"];
				
				%obj.gridX = %x2;
				%obj.gridY = %y2;
				
				%this.movingDownGroup.add(%obj);
				
				//reset x1 and y2 values (turn it blank in the gridSO)
				%this.block[%x1 @ "_" @ %y1 @ "Object"] = "";
				%this.block[%x1 @ "_" @ %y1 @ "Type"] = "";
				
				//physically move it (what the user sees)
				%this.block[%x2 @ "_" @ %y2 @ "Object"].moveTo(%topX + (%x2 * getWord($blockSize, 0)) SPC %topY + (%y2 * getWord($blockSize, 1)), $blockMoveSpeed, 1, 1);
				%movedABlock = 1;
			}
		}
	}
	
	if(%movedABlock) //I dont know why.  It makes it work though.
	{
		%this.updateColumn(%x);
	}
}


//update entire row (move left). input Y value
function gridSO::updateRow(%this, %movedBeforeCount, %movedFrom)
{
	if($updatedRow == 1)
		return;
	else
		$updatedRow = 1;
	
	%y = %this.sizeY - 1;
	
	//does some math for moving the blocks later
	%topX = getWord(sceneWindow2D.getCurrentCameraArea(), 0) + 5;
	%topY = getWord(sceneWindow2D.getCurrentCameraArea(), 1) + 5 - 5; //offset to leave room for stats at the bottom (-5)
	%topX = %topX + ((getWord(sceneWindow2D.getCurrentCameraSize(), 0) - (%this.sizeX * getWord($blockSize, 0))) / 2);
	%topY = %topY + ((getWord(sceneWindow2D.getCurrentCameraSize(), 1) - (%this.sizeY * getWord($blockSize, 1))) / 2);
	
	for(%x = 1; %x <= %this.sizeX - 1; %x++) //start one block to the right
	{
		%obj = %this.getBlockObject(%x, %y);
		if(isObject(%obj))
		{
			%count = 1;
			%nextObj = %this.block[%x - %count @ "_" @ %y @ "Object"];
			if(!isObject(%nextObj))
			{
				if(%movedFrom $= "")
					%movedFrom = %x;
				
				while(!isObject(%nextObj) && %x - %count >= 0)
				{
					%count++;
					%nextObj = %this.block[%x - %count @ "_" @ %y @ "Object"];
				}
				
				if(%count > 1)
					%count--;
				
				//move it - can't use function because it must be done instantly, before the next "for" loop
				//set x2 and y2 values (move it in the gridSO)
				
				for(%i = 0; %i < %this.sizeY; %i++)
				{
					%x1 = %x;
					%y1 = %y - %i;
					%x2 = %x - %count;
					%y2 = %y - %i;
					if(isObject(%this.block[%x1 @ "_" @ %y1 @ "Object"]))
					{
						%this.block[%x2 @ "_" @ %y2 @ "Object"] = %this.block[%x1 @ "_" @ %y1 @ "Object"];
						%this.block[%x2 @ "_" @ %y2 @ "Type"] = %this.block[%x1 @ "_" @ %y1 @ "Type"];
						
						%this.block[%x2 @ "_" @ %y2 @ "Object"].gridX = %x2;
						%this.block[%x2 @ "_" @ %y2 @ "Object"].gridY = %y2;
						
						//reset x1 and y2 values (turn it blank in the gridSO)
						%this.block[%x1 @ "_" @ %y1 @ "Object"] = "";
						%this.block[%x1 @ "_" @ %y1 @ "Type"] = "";
						
						//physically move it (what the user sees)
						%this.block[%x2 @ "_" @ %y2 @ "Object"].moveTo(%topX + (%x2 * getWord($blockSize, 0)) SPC %topY + (%y2 * getWord($blockSize, 1)), $blockMoveSpeed, 1, 1);
						%movedABlock = 1;
					}
				}
			}
		}
	}
	
	if(isEventPending($gameOverCheckSched))
		cancel($gameOverCheckSched);
	$gameOverCheckSched = %this.schedule($gameOverDelay, "gameOverCheck");
}


//this function assumes the target block no longer exists
//UNUSED.
function gridSO::moveBlockTo(%this, %x1, %y1, %x2, %y2)
{
	//set x2 and y2 values (move it in the gridSO)
	%this.block[%x2 @ "_" @ %y2 @ "Object"] = %this.block[%x1 @ "_" @ %y1 @ "Object"];
	%this.block[%x2 @ "_" @ %y2 @ "Type"] = %this.block[%x1 @ "_" @ %y1 @ "Type"];
	%this.block[%x2 @ "_" @ %y2 @ "Object"].gridX = %x2;
	%this.block[%x2 @ "_" @ %y2 @ "Object"].gridY = %y2;
	
	//reset x1 and y2 values (turn it blank in the gridSO)
	%this.block[%x1 @ "_" @ %y1 @ "Object"] = "";
	%this.block[%x1 @ "_" @ %y1 @ "Type"] = "";
	
	//physically move it (what the user sees)
	//first, do some math to find the exact position
	%topX = getWord(sceneWindow2D.getCurrentCameraArea(), 0) + 5;
	%topY = getWord(sceneWindow2D.getCurrentCameraArea(), 1) + 5 - 5; //offset to leave room for stats at the bottom (-5)
	%topX = %topX + ((getWord(sceneWindow2D.getCurrentCameraSize(), 0) - (%this.sizeX * getWord($blockSize, 0))) / 2);
	%topY = %topY + ((getWord(sceneWindow2D.getCurrentCameraSize(), 1) - (%this.sizeY * getWord($blockSize, 1))) / 2);
	%this.block[%x2 @ "_" @ %y2 @ "Object"].moveTo(%topX + (%x2 * getWord($blockSize, 0)) SPC %topY + (%y2 * getWord($blockSize, 1)), $blockMoveSpeed, 1, 1);
}

//input related stuff (clicking)
function sceneWindow2D::onMouseDown(%this, %mod, %pos, %mouseClicks)  
{
	if(!isObject($Grid))
		return;
	
	if($Grid.movingDownGroup.getCount() > 0)
		return;
	
	if(%mouseClicks >= 2 && $Grid.chainCount > 0)
	{
		$grid.explodeChain();
		$grid.updateGrid();
		return;
	}
	
	%obj = $sceneGraph.pickPoint(%pos, -1, BIT($blockLayer));
	%obj = trim(%obj);
	
	//clear current chain
	$Grid.clearChain(1);
	
	if(isObject(%obj) && !$Grid.blockIsSingle(%obj.gridX, %obj.gridY))
	{
		$Grid.addBlockToChain(%obj.gridX, %obj.gridY);
		
		//play chain select sound
		alxPlay("chainSelect" @ getRandom(1, $chainSelectAudioCount));
		
		$Grid.schedule(50, "displayChain");
	}
}

function sceneWindow2D::onRightMouseDown(%this, %mod, %pos, %mouseClicks)  
{
	if(!isObject($Grid))
		return;
	
	$grid.explodeChain();
	$grid.updateGrid();
}

function gridSO::delete(%this)
{
	%this.chainDisplayGroup.delete();
	%this.movingDownGroup.delete();
	
	for(%x = 0; %x < %this.sizeX; %x++)
	{
		for(%y = 0; %y < %this.sizeY; %y++)
		{
			%obj = %this.block[%x @ "_" @ %y @ "Object"];
			if(isObject(%obj))
				%obj.delete();
		}
	}
	
	for(%i = 1; %i <= %this.varietyCount; %i++)
	{
		%this.varietyRemainingObject[%i].delete();
		%this.varietyRemainingText[%i].delete();
	}
	
	parent::delete(%this);
}

function gridSO::gameOverCheck(%this)
{
	for(%x = 0; %x < %this.sizeX; %x++)
	{
		for(%y = 0; %y < %this.sizeY; %y++)
		{
			%obj = %this.block[%x @ "_" @ %y @ "Object"];
			if(isObject(%obj))
				return;
		}
	}

	schedule(100, 0, "alxPlay", flawlessVictory);
}

function gridSO::updateVarietyRemaining(%this)
{
	%typeCount = %this.varietyCount;
	for(%x = 0; %x < %this.sizeX; %x++)
	{
		for(%y = 0; %y < %this.sizeY; %y++)
		{
			%t = %this.block[%x @ "_" @ %y @ "Type"];
			%type[%t]++;
		}
	}
	
	for(%i = 1; %i <= %typeCount; %i++)
	{
		if(%type[%i] $= "")
			%type[%i] = 0;
		$remainingCount[%i] = %type[%i];
		%this.varietyRemainingText[%i].setText(%type[%i]);
	}
}

//%size should be "small" "medium" or "large"
function gridSO::explodeBlock(%this, %x, %y, %type, %chainSize, %size, %width, %height)
{
	%topX = getWord(sceneWindow2D.getCurrentCameraArea(), 0) + 5;
	%topY = getWord(sceneWindow2D.getCurrentCameraArea(), 1) + 5 - 5; //offset to leave room for stats at the bottom (-5)
	%topX = %topX + ((getWord(sceneWindow2D.getCurrentCameraSize(), 0) - (%this.sizeX * getWord($blockSize, 0))) / 2);
	%topY = %topY + ((getWord(sceneWindow2D.getCurrentCameraSize(), 1) - (%this.sizeY * getWord($blockSize, 1))) / 2);
	
	%pos = %topX + (%x * getWord($blockSize, 0)) SPC %topY + (%y * getWord($blockSize, 1));
	
	//draw explosion
	%explosion = new t2dStaticSprite()
	{
			imageMap = "explosion" @ %size;
			size = $blockSize;
			Layer = $blockLayer - 1;
			position = %pos;
			CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
	};
	$sceneGraph.add(%explosion);
	%explosion.doAnimation();
	
	//debris stuff
	%debrisCount = getRandom(4, 6);
	
	if(%size !$= "small")
		%debrisCount += 2;
	
	if(%width == 1)
		%width = 1;
	if(%height == 1)
		%height = 1;
	
	//create debris
	for(%i = 0; %i < %debrisCount; %i++)
	{
		%num = getRandom(1, 2);
		%debris = new t2dStaticSprite()
		{
				imageMap = "block" @ %type @ "Debris" @ %num;
				size = $debrisSize;
				Layer = $blockLayer - 2;
				position = %pos;
				CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
		};
		$sceneGraph.add(%debris);
		%this.debrisGroup.add(%debris);
		
		%speedY = getRandom(15 + (%height * 14), 40 + (%height * 26));
		%speedX = getLimitedRandom(%width * -16, %width * -2, %width * 16, %width * 2);
		%debris.setLinearVelocity(%speedX, %speedY * -1);
		%debris.setConstantForce("0 3");
		%debris.schedule(5000, delete);
	}
}

function getLimitedRandom(%low, %mid1, %high, %mid2)
{
	if(getRandom(0, 1))
		return(getRandom(%low, %mid1));
	else
		return(getRandom(%high, %mid2));
}


//==================================
//sound stuff
//==================================
//this code will make it so it's impossible to get the same explosion or break sound twice in a row
//sounds much nicer, and is free of infinite loops (no whiles)
//small note - the 'break' sounds are just increased incrementally as opposed to randomly - this makes it sound a bit more varied (I ordered the files specially)
//$lastExplosionAudio = "";
//$lastBreakAudio = "0";
//$lastAnnouncer = "0";
function gridSO::playExplosionSounds(%this, %size, %chainSize, %highestX, %lowestX)
{
	%middle = mFloor(%this.sizeX / 2);
	%fourth = mFloor(%this.sizeX / 4);
	if(%highestX > %middle + 1)
	{
		if(%lowestX >= %middle)
			%side = "right";
		if(%highestX > (%middle + %fourth) + 1)
			%power += 0.5;
	}
	
	if(%lowestX < %middle - 1)
	{
		if(%highestX <= %middle)
			%side = "left";
		if(%lowestX < (%middle - %fourth) - 1)
			%power += 0.5;
	}
	
	if(%lowestX > %middle - 1 && %lowestX < %middle + 1)
		%side = "";
	if(%highestX > %middle - 1 && %highestX < %middle + 1)
		%side = "";
	
	%pos = 0;
	%z = 0.75;
	
	if(%size $= "large")
		%z += 0.25;
	
	if(%side $= "left")
	{
		%pos = -0.6;
		%pos -= %power;
	}
	
	if(%side $= "right")
	{
		%pos = 0.6;
		%pos += %power;
	}
	
	if(%chainSize >= $announcerCutoff)
	{
		$lastAnnouncer++;
		if($lastAnnouncer > $announcerAudioCount)
			$lastAnnouncer = 1;
		
		schedule(1000, 0, "doAnnouncer", $lastAnnouncer);
	}
	
	%expRand = getRandom(1, $explode[%size @ "AudioCount"]);
	if(%expRand == $lastExplosionAudio)
	{
		if(%expRand == $explode[%size @ "AudioCount"])
			%expRand = 1;
		else
			%expRand++;
	}
	
	$lastExplosionHandle = alxPlay(%size @ "Explode" @ %expRand, %pos, 0, %z);
	$lastExplosionAudio = %expRand;
	
	%breakRand = $lastBreakAudio;
	if(%breakRand == $lastBreakAudio)
	{
		if(%breakRand == $breakAudioCount)
			%breakRand = 1;
		else
			%breakRand++;
	}
	
	alxPlay("break" @ %breakRand, %pos, 0, %z);
	$lastBreakAudio = %breakRand;
}

function doAnnouncer(%num)
{
	alxPlay("announcer" @ %num);
	//schedule(1050, 0, "unDimMusic");
}

//function unDimMusic()
//{
//	alxSetChannelVolume(1, $pref::Audio::channelVolume1);
//}

function setUpFullScreen()
{
	%list = getResolutionList("OpenGL");
}

function alxAddToQueue(%sound)
{
	if($alxQueueCount $= "")
		$alxQueueCount = 0;
		
	$alxQueue[$alxQueueCount] = %sound;
	$alxQueueCount++;
	echo("added");
	alxCheckQueue();
}

function alxCheckQueue()
{
	if(!alxIsPlaying($lastExplosionHandle))
	{
		//alxSetChannelVolume(1, 0.52);
		alxPlay($alxQueue0);
		//move everything down
		for(%i = 1; %i < $alxQueueCount; %i++)
		{
			$alxQueue[%i - 1] = $alxQueue[%i];
		}
		$alxQueueCount--;
	}
	
	if($alxQueueCount > 0)
		$alxQueueSched = schedule(30, 0, "alxCheckQueue");
}

//scoring
function gridSO::doChainScoring(%this, %size, %chainSize)
{
	%points = mPow(%this.varietyCount, 3) * mPow((%chainSize - 1), 2);
	$pointsAddingToScore = %points;
	increasePoints();
}

function displayCurrentScore()
{
	//E9DF95
	//if($pointsAddingToScore > 10000)
	//	scoreText.setText("<just:center>Score:\n<color:DFD78F>" @ $currentScore);
	//else
		scoreText.setText("<just:center>Score:\n" @ $currentScore);
}

function resetScore()
{
	$pointsAddingToScore = 0;
	$currentScore = 0;
	displayCurrentScore();
}

function increasePoints()
{
	if($pointsAddingToScore > 10000)
	{
		$pointsAddingToScore -= 24;
			$currentScore += 24;
	}else{
		if($pointsAddingToScore > 1000)
		{
			$pointsAddingToScore -= 12;
			$currentScore += 12;
		}else{
			if($pointsAddingToScore > 100)
			{
				$pointsAddingToScore -= 4;
				$currentScore += 4;
			}else{
				$pointsAddingToScore--;
				$currentScore++;
			}
		}
	}
	displayCurrentScore();
	
	if($pointsAddingToScore > 0)
	{
		if(isEventPending($pointsIncSched))
			cancel($pointsIncSched);
		
		$pointIncSched = schedule(1, 0, "increasePoints");
	}
}
